<%-- Copyright (c) Oracle Corporation 2002. All Rights Reserved. --%>

<%--
    NAME
        PhotoAlbumUploadForm.jsp

    DESCRIPTION
        PhotoAlbumUploadForm.jsp is one component of a JavaServer Pages
        application that demonstrates the use of Oracle Multimedia Java 
        Classes for Servlets and JSPs by implementing a simple photo album 
        application. This page displays an HTML form that lets users upload 
        a new image into the photo album.

    NOTES
        See the README.txt file for information on how to build and
        run the demo.
--%>

<%@ page language="java" %>

<%-- HTML header --%>
<html lang="EN">
<head>
<title>Oracle Multimedia JavaServer Pages Photo Album Demo</title>
</head>

<body>

<%-- Page heading --%>
<table border="0" width="100%">
  <tr>
    <td colspan="2" bgcolor="#f7f7e7" align="center"><font size="+2">
      Oracle Multimedia JavaServer Pages Photo Album Demo</font>
    </td>
  </tr>
</table>

<%-- Display any error information from a previous attempt --%>
<%
    String errorMessage = request.getParameter( "error" );
    if ( errorMessage != null )
    {
%>
       <p>
       <img src="images/error_qualifier.png" name="errorIcon" alt="Error:">   <%= errorMessage %>
       </p>
<%
    }
%>

<%-- Display header --%>
<p>
<font size=3 color="#336699"><b>Upload a new photo</b></font><hr size=1>
</p>

<%-- Output the form --%>
<p>
<form action="PhotoAlbumInsertPhoto.jsp"
      method="post" enctype="multipart/form-data">
<table border="0" width="100%" cellspacing="0" summary="photo upload form">
  <tr bgcolor="#f7f7e7">
    <td scope="col" colspan="2">&nbsp;</td>
  </tr>
  <tr bgcolor="#f7f7e7">
    <td scope="col" valign="top"><label for="description_id"><b>Description:</b>
        <br><font size="-1">(Optional)</font></label></td>
    <td scope="col" >
      <input id="description_id" type="text" name="description" length="40">
      <br><font size="-1">(e.g., My vacation)</font>
    </td>
  </tr>
  <tr bgcolor="#f7f7e7">
    <td scope="col" valign="top"><label for="location_id"><b>Location:</b>
        <br><font size="-1">(Optional)</font></label></td>
    <td scope="col" >
      <input id="location_id" type="text" name="location" length="40">
      <br><font size="-1">(e.g., Somewhere sunny)</font>
    </td>
  </tr>
  <tr bgcolor="#f7f7e7">
    <td scope="col" valign="top"><label for="filename_id"><b>File name:</b>
      </label></td>
    <td scope="col" >
      <input id="filename_id" type="file" name="photo">
      <br><font size="-1">(e.g., island.jpg)</font>
    </td>
  </tr>
  <tr bgcolor="#f7f7e7">
    <td colspan="2">
      &nbsp;
    </td>
  </tr>
  <tr bgcolor="#f7f7e7">
    <td colspan="2">
      <input type="submit" value="Upload photo" >
    </td>
  </tr>
  <tr bgcolor="#f7f7e7">
    <td colspan="2">
      &nbsp;
    </td>
  </tr>
</table>
</form>
</p>

<%-- Output a link to return to the main page --%>
<p>
<table width="100%">
  <tr bgcolor="#f7f7e7">
    <td  align="center">
      <a href="PhotoAlbum.jsp">Return to photo album</a>
    </td>
  </tr>
</table>
</p>

<%-- Finish the page --%>
</body>
</html>

